/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.BitSet;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.util.ByteSequence;
import org.apache.bcel.util.Class2HTML;
import org.apache.bcel.util.ConstantHTML;

final class CodeHTML {
    private final String class_name;
    private final PrintWriter file;
    private BitSet goto_set;
    private final ConstantPool constant_pool;
    private final ConstantHTML constant_html;
    private static boolean wide = false;

    CodeHTML(String dir, String class_name, Method[] methods, ConstantPool constant_pool, ConstantHTML constant_html) throws IOException {
        this.class_name = class_name;
        this.constant_pool = constant_pool;
        this.constant_html = constant_html;
        this.file = new PrintWriter(new FileOutputStream(String.valueOf(dir) + class_name + "_code.html"));
        this.file.println("<HTML><BODY BGCOLOR=\"#C0C0C0\">");
        int i = 0;
        while (i < methods.length) {
            this.writeMethod(methods[i], i);
            ++i;
        }
        this.file.println("</BODY></HTML>");
        this.file.close();
    }

    private String codeToHTML(ByteSequence bytes, int method_number) throws IOException {
        int i;
        short opcode = (short)bytes.readUnsignedByte();
        int default_offset = 0;
        int no_pad_bytes = 0;
        StringBuilder buf = new StringBuilder(256);
        buf.append("<TT>").append(Const.getOpcodeName(opcode)).append("</TT></TD><TD>");
        if (opcode == 170 || opcode == 171) {
            int remainder = bytes.getIndex() % 4;
            no_pad_bytes = remainder == 0 ? 0 : 4 - remainder;
            i = 0;
            while (i < no_pad_bytes) {
                bytes.readByte();
                ++i;
            }
            default_offset = bytes.readInt();
        }
        switch (opcode) {
            case 170: {
                int low = bytes.readInt();
                int high = bytes.readInt();
                int offset = bytes.getIndex() - 12 - no_pad_bytes - 1;
                default_offset += offset;
                buf.append("<TABLE BORDER=1><TR>");
                int[] jump_table = new int[high - low + 1];
                int i2 = 0;
                while (i2 < jump_table.length) {
                    jump_table[i2] = offset + bytes.readInt();
                    buf.append("<TH>").append(low + i2).append("</TH>");
                    ++i2;
                }
                buf.append("<TH>default</TH></TR>\n<TR>");
                int[] nArray = jump_table;
                int n = jump_table.length;
                i = 0;
                while (i < n) {
                    int element = nArray[i];
                    buf.append("<TD><A HREF=\"#code").append(method_number).append("@").append(element).append("\">").append(element).append("</A></TD>");
                    ++i;
                }
                buf.append("<TD><A HREF=\"#code").append(method_number).append("@").append(default_offset).append("\">").append(default_offset).append("</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 171: {
                int npairs = bytes.readInt();
                int offset = bytes.getIndex() - 8 - no_pad_bytes - 1;
                int[] jump_table = new int[npairs];
                default_offset += offset;
                buf.append("<TABLE BORDER=1><TR>");
                i = 0;
                while (i < npairs) {
                    int match = bytes.readInt();
                    jump_table[i] = offset + bytes.readInt();
                    buf.append("<TH>").append(match).append("</TH>");
                    ++i;
                }
                buf.append("<TH>default</TH></TR>\n<TR>");
                i = 0;
                while (i < npairs) {
                    buf.append("<TD><A HREF=\"#code").append(method_number).append("@").append(jump_table[i]).append("\">").append(jump_table[i]).append("</A></TD>");
                    ++i;
                }
                buf.append("<TD><A HREF=\"#code").append(method_number).append("@").append(default_offset).append("\">").append(default_offset).append("</A></TD></TR>\n</TABLE>\n");
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                int index = bytes.getIndex() + bytes.readShort() - 1;
                buf.append("<A HREF=\"#code").append(method_number).append("@").append(index).append("\">").append(index).append("</A>");
                break;
            }
            case 200: 
            case 201: {
                int windex = bytes.getIndex() + bytes.readInt() - 1;
                buf.append("<A HREF=\"#code").append(method_number).append("@").append(windex).append("\">").append(windex).append("</A>");
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int vindex;
                if (wide) {
                    vindex = bytes.readShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                }
                buf.append("%").append(vindex);
                break;
            }
            case 196: {
                wide = true;
                buf.append("(wide)");
                break;
            }
            case 188: {
                buf.append("<FONT COLOR=\"#00FF00\">").append(Const.getTypeName(bytes.readByte())).append("</FONT>");
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                int index = bytes.readShort();
                ConstantFieldref c1 = (ConstantFieldref)this.constant_pool.getConstant(index, (byte)9);
                int class_index = c1.getClassIndex();
                String name = this.constant_pool.getConstantString(class_index, (byte)7);
                name = Utility.compactClassName(name, false);
                index = c1.getNameAndTypeIndex();
                String field_name = this.constant_pool.constantToString(index, (byte)12);
                if (name.equals(this.class_name)) {
                    buf.append("<A HREF=\"").append(this.class_name).append("_methods.html#field").append(field_name).append("\" TARGET=Methods>").append(field_name).append("</A>\n");
                    break;
                }
                buf.append(this.constant_html.referenceConstant(class_index)).append(".").append(field_name);
                break;
            }
            case 187: 
            case 192: 
            case 193: {
                short index = bytes.readShort();
                buf.append(this.constant_html.referenceConstant(index));
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: {
                String name;
                int index;
                int class_index;
                ConstantCP c;
                short m_index = bytes.readShort();
                if (opcode == 185) {
                    bytes.readUnsignedByte();
                    bytes.readUnsignedByte();
                    c = (ConstantInterfaceMethodref)this.constant_pool.getConstant(m_index, (byte)11);
                    class_index = c.getClassIndex();
                    index = c.getNameAndTypeIndex();
                    name = Class2HTML.referenceClass(class_index);
                } else if (opcode == 186) {
                    bytes.readUnsignedByte();
                    bytes.readUnsignedByte();
                    c = (ConstantInvokeDynamic)this.constant_pool.getConstant(m_index, (byte)18);
                    index = c.getNameAndTypeIndex();
                    name = "#" + ((ConstantInvokeDynamic)c).getBootstrapMethodAttrIndex();
                } else {
                    c = (ConstantMethodref)this.constant_pool.getConstant(m_index, (byte)10);
                    class_index = c.getClassIndex();
                    index = c.getNameAndTypeIndex();
                    name = Class2HTML.referenceClass(class_index);
                }
                String str = Class2HTML.toHTML(this.constant_pool.constantToString(this.constant_pool.getConstant(index, (byte)12)));
                ConstantNameAndType c2 = (ConstantNameAndType)this.constant_pool.getConstant(index, (byte)12);
                String signature = this.constant_pool.constantToString(c2.getSignatureIndex(), (byte)1);
                String[] args = Utility.methodSignatureArgumentTypes(signature, false);
                String type = Utility.methodSignatureReturnType(signature, false);
                buf.append(name).append(".<A HREF=\"").append(this.class_name).append("_cp.html#cp").append(m_index).append("\" TARGET=ConstantPool>").append(str).append("</A>").append("(");
                int i3 = 0;
                while (i3 < args.length) {
                    buf.append(Class2HTML.referenceType(args[i3]));
                    if (i3 < args.length - 1) {
                        buf.append(", ");
                    }
                    ++i3;
                }
                buf.append("):").append(Class2HTML.referenceType(type));
                break;
            }
            case 19: 
            case 20: {
                short index = bytes.readShort();
                buf.append("<A HREF=\"").append(this.class_name).append("_cp.html#cp").append(index).append("\" TARGET=\"ConstantPool\">").append(Class2HTML.toHTML(this.constant_pool.constantToString(index, this.constant_pool.getConstant(index).getTag()))).append("</a>");
                break;
            }
            case 18: {
                int index = bytes.readUnsignedByte();
                buf.append("<A HREF=\"").append(this.class_name).append("_cp.html#cp").append(index).append("\" TARGET=\"ConstantPool\">").append(Class2HTML.toHTML(this.constant_pool.constantToString(index, this.constant_pool.getConstant(index).getTag()))).append("</a>");
                break;
            }
            case 189: {
                short index = bytes.readShort();
                buf.append(this.constant_html.referenceConstant(index));
                break;
            }
            case 197: {
                short index = bytes.readShort();
                byte dimensions = bytes.readByte();
                buf.append(this.constant_html.referenceConstant(index)).append(":").append(dimensions).append("-dimensional");
                break;
            }
            case 132: {
                short constant;
                int vindex;
                if (wide) {
                    vindex = bytes.readShort();
                    constant = bytes.readShort();
                    wide = false;
                } else {
                    vindex = bytes.readUnsignedByte();
                    constant = bytes.readByte();
                }
                buf.append("%").append(vindex).append(" ").append(constant);
                break;
            }
            default: {
                if (Const.getNoOfOperands(opcode) <= 0) break;
                int i4 = 0;
                while ((long)i4 < Const.getOperandTypeCount(opcode)) {
                    switch (Const.getOperandType(opcode, i4)) {
                        case 8: {
                            buf.append(bytes.readUnsignedByte());
                            break;
                        }
                        case 9: {
                            buf.append(bytes.readShort());
                            break;
                        }
                        case 10: {
                            buf.append(bytes.readInt());
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unreachable default case reached! " + Const.getOperandType(opcode, i4));
                        }
                    }
                    buf.append("&nbsp;");
                    ++i4;
                }
                break block0;
            }
        }
        buf.append("</TD>");
        return buf.toString();
    }

    private void findGotos(ByteSequence bytes, Code code) throws IOException {
        this.goto_set = new BitSet(bytes.available());
        if (code != null) {
            Attribute[] attributes;
            CodeException[] ce;
            CodeException[] codeExceptionArray = ce = code.getExceptionTable();
            int n = ce.length;
            int n2 = 0;
            while (n2 < n) {
                CodeException cex = codeExceptionArray[n2];
                this.goto_set.set(cex.getStartPC());
                this.goto_set.set(cex.getEndPC());
                this.goto_set.set(cex.getHandlerPC());
                ++n2;
            }
            Attribute[] attributeArray = attributes = code.getAttributes();
            int n3 = attributes.length;
            n = 0;
            while (n < n3) {
                Attribute attribute = attributeArray[n];
                if (attribute.getTag() == 5) {
                    LocalVariable[] vars;
                    LocalVariable[] localVariableArray = vars = ((LocalVariableTable)attribute).getLocalVariableTable();
                    int n4 = vars.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        LocalVariable var = localVariableArray[n5];
                        int start = var.getStartPC();
                        int end = start + var.getLength();
                        this.goto_set.set(start);
                        this.goto_set.set(end);
                        ++n5;
                    }
                    break;
                }
                ++n;
            }
        }
        block8: while (bytes.available() > 0) {
            int opcode = bytes.readUnsignedByte();
            switch (opcode) {
                case 170: 
                case 171: {
                    int index;
                    int offset;
                    int remainder = bytes.getIndex() % 4;
                    int no_pad_bytes = remainder == 0 ? 0 : 4 - remainder;
                    int j = 0;
                    while (j < no_pad_bytes) {
                        bytes.readByte();
                        ++j;
                    }
                    int default_offset = bytes.readInt();
                    if (opcode == 170) {
                        int low = bytes.readInt();
                        int high = bytes.readInt();
                        offset = bytes.getIndex() - 12 - no_pad_bytes - 1;
                        this.goto_set.set(default_offset += offset);
                        int j2 = 0;
                        while (j2 < high - low + 1) {
                            index = offset + bytes.readInt();
                            this.goto_set.set(index);
                            ++j2;
                        }
                        continue block8;
                    }
                    int npairs = bytes.readInt();
                    offset = bytes.getIndex() - 8 - no_pad_bytes - 1;
                    this.goto_set.set(default_offset += offset);
                    int j3 = 0;
                    while (j3 < npairs) {
                        bytes.readInt();
                        index = offset + bytes.readInt();
                        this.goto_set.set(index);
                        ++j3;
                    }
                    continue block8;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    int index = bytes.getIndex() + bytes.readShort() - 1;
                    this.goto_set.set(index);
                    break;
                }
                case 200: 
                case 201: {
                    int index = bytes.getIndex() + bytes.readInt() - 1;
                    this.goto_set.set(index);
                    break;
                }
                default: {
                    bytes.unreadByte();
                    this.codeToHTML(bytes, 0);
                }
            }
        }
    }

    private void writeMethod(Method method, int method_number) throws IOException {
        String signature = method.getSignature();
        String[] args = Utility.methodSignatureArgumentTypes(signature, false);
        String type = Utility.methodSignatureReturnType(signature, false);
        String name = method.getName();
        String html_name = Class2HTML.toHTML(name);
        String access = Utility.accessToString(method.getAccessFlags());
        access = Utility.replace(access, " ", "&nbsp;");
        Attribute[] attributes = method.getAttributes();
        this.file.print("<P><B><FONT COLOR=\"#FF0000\">" + access + "</FONT>&nbsp;" + "<A NAME=method" + method_number + ">" + Class2HTML.referenceType(type) + "</A>&nbsp<A HREF=\"" + this.class_name + "_methods.html#method" + method_number + "\" TARGET=Methods>" + html_name + "</A>(");
        int i = 0;
        while (i < args.length) {
            this.file.print(Class2HTML.referenceType(args[i]));
            if (i < args.length - 1) {
                this.file.print(",&nbsp;");
            }
            ++i;
        }
        this.file.println(")</B></P>");
        Code c = null;
        byte[] code = null;
        if (attributes.length > 0) {
            this.file.print("<H4>Attributes</H4><UL>\n");
            int i2 = 0;
            while (i2 < attributes.length) {
                byte tag = attributes[i2].getTag();
                if (tag != -1) {
                    this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#method" + method_number + "@" + i2 + "\" TARGET=Attributes>" + Const.getAttributeName(tag) + "</A></LI>\n");
                } else {
                    this.file.print("<LI>" + attributes[i2] + "</LI>");
                }
                if (tag == 2) {
                    c = (Code)attributes[i2];
                    Attribute[] attributes2 = c.getAttributes();
                    code = c.getCode();
                    this.file.print("<UL>");
                    int j = 0;
                    while (j < attributes2.length) {
                        tag = attributes2[j].getTag();
                        this.file.print("<LI><A HREF=\"" + this.class_name + "_attributes.html#" + "method" + method_number + "@" + i2 + "@" + j + "\" TARGET=Attributes>" + Const.getAttributeName(tag) + "</A></LI>\n");
                        ++j;
                    }
                    this.file.print("</UL>");
                }
                ++i2;
            }
            this.file.println("</UL>");
        }
        if (code != null) {
            Throwable throwable = null;
            Object var13_17 = null;
            try (ByteSequence stream = new ByteSequence(code);){
                stream.mark(stream.available());
                this.findGotos(stream, c);
                stream.reset();
                this.file.println("<TABLE BORDER=0><TR><TH ALIGN=LEFT>Byte<BR>offset</TH><TH ALIGN=LEFT>Instruction</TH><TH ALIGN=LEFT>Argument</TH>");
                while (stream.available() > 0) {
                    int offset = stream.getIndex();
                    String str = this.codeToHTML(stream, method_number);
                    String anchor = "";
                    if (this.goto_set.get(offset)) {
                        anchor = "<A NAME=code" + method_number + "@" + offset + "></A>";
                    }
                    String anchor2 = stream.getIndex() == code.length ? "<A NAME=code" + method_number + "@" + code.length + ">" + offset + "</A>" : "" + offset;
                    this.file.println("<TR VALIGN=TOP><TD>" + anchor2 + "</TD><TD>" + anchor + str + "</TR>");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.file.println("<TR><TD> </A></TD></TR>");
            this.file.println("</TABLE>");
        }
    }
}

